"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    description: str = None,
    pricing_plan: str = None,
    reservation_plan_settings: Dict = None,
    status: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new transcoding queue. For information about queues, see Working With Queues in the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html

    Args:
        description(str, optional): Optional. A description of the queue that you are creating. Defaults to None.
        name(str): The name of the queue that you are creating.
        pricing_plan(str, optional): Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment. When you use the API to create a queue, the default is on-demand. Defaults to None.
        reservation_plan_settings(Dict, optional): Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues. Defaults to None.
        status(str, optional): Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin. Defaults to None.
        tags(Dict, optional): The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.queue.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.queue.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="create_queue",
        op_kwargs={
            "Description": description,
            "Name": name,
            "PricingPlan": pricing_plan,
            "ReservationPlanSettings": reservation_plan_settings,
            "Status": status,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Permanently delete a queue you have created.

    Args:
        name(str): The name of the queue that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.queue.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.queue.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="delete_queue",
        op_kwargs={"Name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve the JSON for a specific queue.

    Args:
        name(str): The name of the queue that you want information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.queue.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.queue.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="get_queue",
        op_kwargs={"Name": name},
    )


async def list_all(
    hub,
    ctx,
    list_by: str = None,
    max_results: int = None,
    next_token: str = None,
    order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of them. To retrieve the next twenty queues, use the nextToken string returned with the array.

    Args:
        list_by(str, optional): Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don't specify, the service will list them by creation date. Defaults to None.
        max_results(int, optional): Optional. Number of queues, up to twenty, that will be returned at one time. Defaults to None.
        next_token(str, optional): Use this string, provided with the response to a previous request, to request the next batch of queues. Defaults to None.
        order(str, optional): Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.queue.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.queue.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="list_queues",
        op_kwargs={
            "ListBy": list_by,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Order": order,
        },
    )


async def update(
    hub,
    ctx,
    name: str,
    description: str = None,
    reservation_plan_settings: Dict = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modify one of your existing queues.

    Args:
        description(str, optional): The new description for the queue, if you are changing it. Defaults to None.
        name(str): The name of the queue that you are modifying.
        reservation_plan_settings(Dict, optional): The new details of your pricing plan for your reserved queue. When you set up a new pricing plan to replace an expired one, you enter into another 12-month commitment. When you add capacity to your queue by increasing the number of RTS, you extend the term of your commitment to 12 months from when you add capacity. After you make these commitments, you can't cancel them. Defaults to None.
        status(str, optional): Pause or activate a queue by changing its status between ACTIVE and PAUSED. If you pause a queue, jobs in that queue won't begin. Jobs that are running when you pause the queue continue to run until they finish or result in an error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.queue.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.queue.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="update_queue",
        op_kwargs={
            "Description": description,
            "Name": name,
            "ReservationPlanSettings": reservation_plan_settings,
            "Status": status,
        },
    )
