"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    settings: Dict,
    category: str = None,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new preset. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html

    Args:
        category(str, optional): Optional. A category for the preset you are creating. Defaults to None.
        description(str, optional): Optional. A description of the preset you are creating. Defaults to None.
        name(str): The name of the preset you are creating.
        settings(Dict): Settings for preset.
        tags(Dict, optional): The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.preset.create(ctx, name=value, settings=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.preset.create name=value, settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="create_preset",
        op_kwargs={
            "Category": category,
            "Description": description,
            "Name": name,
            "Settings": settings,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Permanently delete a preset you have created.

    Args:
        name(str): The name of the preset to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.preset.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.preset.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="delete_preset",
        op_kwargs={"Name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve the JSON for a specific preset.

    Args:
        name(str): The name of the preset.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.preset.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.preset.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="get_preset",
        op_kwargs={"Name": name},
    )


async def list_all(
    hub,
    ctx,
    category: str = None,
    list_by: str = None,
    max_results: int = None,
    next_token: str = None,
    order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list of them. To retrieve the next twenty presets, use the nextToken string returned with the array.

    Args:
        category(str, optional): Optionally, specify a preset category to limit responses to only presets from that category. Defaults to None.
        list_by(str, optional): Optional. When you request a list of presets, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don't specify, the service will list them by name. Defaults to None.
        max_results(int, optional): Optional. Number of presets, up to twenty, that will be returned at one time. Defaults to None.
        next_token(str, optional): Use this string, provided with the response to a previous request, to request the next batch of presets. Defaults to None.
        order(str, optional): Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.preset.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.preset.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="list_presets",
        op_kwargs={
            "Category": category,
            "ListBy": list_by,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Order": order,
        },
    )


async def update(
    hub,
    ctx,
    name: str,
    category: str = None,
    description: str = None,
    settings: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modify one of your existing presets.

    Args:
        category(str, optional): The new category for the preset, if you are changing it. Defaults to None.
        description(str, optional): The new description for the preset, if you are changing it. Defaults to None.
        name(str): The name of the preset you are modifying.
        settings(Dict, optional): Settings for preset. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.preset.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.preset.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="update_preset",
        op_kwargs={
            "Category": category,
            "Description": description,
            "Name": name,
            "Settings": settings,
        },
    )
