"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    order: str = None,
    queue: str = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process, completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the twenty next most recent jobs, use the nextToken string returned with the array.

    Args:
        max_results(int, optional): Optional. Number of jobs, up to twenty, that will be returned at one time. Defaults to None.
        next_token(str, optional): Optional. Use this string, provided with the response to a previous request, to request the next batch of jobs. Defaults to None.
        order(str, optional): Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource. Defaults to None.
        queue(str, optional): Optional. Provide a queue name to get back only jobs from that queue. Defaults to None.
        status(str, optional): Optional. A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.jobs.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.jobs.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="list_jobs",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "Order": order,
            "Queue": queue,
            "Status": status,
        },
    )
