"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    settings: Dict,
    acceleration_settings: Dict = None,
    category: str = None,
    description: str = None,
    hop_destinations: List = None,
    priority: int = None,
    queue: str = None,
    status_update_interval: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new job template. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html

    Args:
        acceleration_settings(Dict, optional): Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide. Defaults to None.
        category(str, optional): Optional. A category for the job template you are creating. Defaults to None.
        description(str, optional): Optional. A description of the job template you are creating. Defaults to None.
        hop_destinations(List, optional): Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide. Defaults to None.
        name(str): The name of the job template you are creating.
        priority(int, optional): Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0. Defaults to None.
        queue(str, optional): Optional. The queue that jobs created from this template are assigned to. If you don't specify this, jobs will go to the default queue. Defaults to None.
        settings(Dict): JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.
        status_update_interval(str, optional): Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error. Defaults to None.
        tags(Dict, optional): The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.job.template.create(
                ctx, name=value, settings=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.job.template.create name=value, settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="create_job_template",
        op_kwargs={
            "AccelerationSettings": acceleration_settings,
            "Category": category,
            "Description": description,
            "HopDestinations": hop_destinations,
            "Name": name,
            "Priority": priority,
            "Queue": queue,
            "Settings": settings,
            "StatusUpdateInterval": status_update_interval,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Permanently delete a job template you have created.

    Args:
        name(str): The name of the job template to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.job.template.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.job.template.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="delete_job_template",
        op_kwargs={"Name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve the JSON for a specific job template.

    Args:
        name(str): The name of the job template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.job.template.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.job.template.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="get_job_template",
        op_kwargs={"Name": name},
    )


async def list_all(
    hub,
    ctx,
    category: str = None,
    list_by: str = None,
    max_results: int = None,
    next_token: str = None,
    order: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array

    Args:
        category(str, optional): Optionally, specify a job template category to limit responses to only job templates from that category. Defaults to None.
        list_by(str, optional): Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don't specify, the service will list them by name. Defaults to None.
        max_results(int, optional): Optional. Number of job templates, up to twenty, that will be returned at one time. Defaults to None.
        next_token(str, optional): Use this string, provided with the response to a previous request, to request the next batch of job templates. Defaults to None.
        order(str, optional): Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.job.template.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.job.template.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="list_job_templates",
        op_kwargs={
            "Category": category,
            "ListBy": list_by,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Order": order,
        },
    )


async def update(
    hub,
    ctx,
    name: str,
    acceleration_settings: Dict = None,
    category: str = None,
    description: str = None,
    hop_destinations: List = None,
    priority: int = None,
    queue: str = None,
    settings: Dict = None,
    status_update_interval: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modify one of your existing job templates.

    Args:
        acceleration_settings(Dict, optional): Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide. Defaults to None.
        category(str, optional): The new category for the job template, if you are changing it. Defaults to None.
        description(str, optional): The new description for the job template, if you are changing it. Defaults to None.
        hop_destinations(List, optional): Optional list of hop destinations. Defaults to None.
        name(str): The name of the job template you are modifying.
        priority(int, optional): Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0. Defaults to None.
        queue(str, optional): The new queue for the job template, if you are changing it. Defaults to None.
        settings(Dict, optional): JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it. Defaults to None.
        status_update_interval(str, optional): Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.job.template.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.job.template.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="update_job_template",
        op_kwargs={
            "AccelerationSettings": acceleration_settings,
            "Category": category,
            "Description": description,
            "HopDestinations": hop_destinations,
            "Name": name,
            "Priority": priority,
            "Queue": queue,
            "Settings": settings,
            "StatusUpdateInterval": status_update_interval,
        },
    )
