"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Permanently cancel a job. Once you have canceled a job, you can't start it again.

    Args:
        id_(str): The Job ID of the job to be cancelled.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.job.init.cancel(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.job.init.cancel id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="mediaconvert", operation="cancel_job", op_kwargs={"Id": id_}
    )


async def create(
    hub,
    ctx,
    role: str,
    settings: Dict,
    acceleration_settings: Dict = None,
    billing_tags_source: str = None,
    client_request_token: str = None,
    hop_destinations: List = None,
    job_template: str = None,
    priority: int = None,
    queue: str = None,
    simulate_reserved_queue: str = None,
    status_update_interval: str = None,
    tags: Dict = None,
    user_metadata: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new transcoding job. For information about jobs and job settings, see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html

    Args:
        acceleration_settings(Dict, optional): Optional. Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide. Defaults to None.
        billing_tags_source(str, optional): Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on any billing report that you set up. Any transcoding outputs that don't have an associated tag will appear in your billing report unsorted. If you don't choose a valid value for this field, your job outputs will appear on the billing report unsorted. Defaults to None.
        client_request_token(str, optional): Optional. Idempotency token for CreateJob operation. Defaults to None.
        hop_destinations(List, optional): Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide. Defaults to None.
        job_template(str, optional): Optional. When you create a job, you can either specify a job template or specify the transcoding settings individually. Defaults to None.
        priority(int, optional): Optional. Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0. Defaults to None.
        queue(str, optional): Optional. When you create a job, you can specify a queue to send it to. If you don't specify, the job will go to the default queue. For more about queues, see the User Guide topic at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html. Defaults to None.
        role(str): Required. The IAM role you use for creating this job. For details about permissions, see the User Guide topic at the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
        settings(Dict): JobSettings contains all the transcode settings for a job.
        simulate_reserved_queue(str, optional): Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you will see with one RTS in a reserved queue. This setting is disabled by default. Defaults to None.
        status_update_interval(str, optional): Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error. Defaults to None.
        tags(Dict, optional): Optional. The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.  Use standard AWS tags on your job for automatic integration with AWS services and for custom integrations and workflows. Defaults to None.
        user_metadata(Dict, optional): Optional. User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in key/value pairs.  Use only for existing integrations or workflows that rely on job metadata tags. Otherwise, we recommend that you use standard AWS tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.job.init.create(ctx, role=value, settings=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.job.init.create role=value, settings=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="create_job",
        op_kwargs={
            "AccelerationSettings": acceleration_settings,
            "BillingTagsSource": billing_tags_source,
            "ClientRequestToken": client_request_token,
            "HopDestinations": hop_destinations,
            "JobTemplate": job_template,
            "Priority": priority,
            "Queue": queue,
            "Role": role,
            "Settings": settings,
            "SimulateReservedQueue": simulate_reserved_queue,
            "StatusUpdateInterval": status_update_interval,
            "Tags": tags,
            "UserMetadata": user_metadata,
        },
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieve the JSON for a specific completed transcoding job.

    Args:
        id_(str): the job ID of the job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.job.init.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.job.init.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="mediaconvert", operation="get_job", op_kwargs={"Id": id_}
    )
