"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, max_results: int = None, mode: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Send an request with an empty body to the regional API endpoint to get your account API endpoint.

    Args:
        max_results(int, optional): Optional. Max number of endpoints, up to twenty, that will be returned at one time. Defaults to None.
        mode(str, optional): Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if any exist, or to create an endpoint for you and return it if one doesn't already exist. Specify GET_ONLY to return your endpoints if any exist, or an empty list if none exist. Defaults to None.
        next_token(str, optional): Use this string, provided with the response to a previous request, to request the next batch of endpoints. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.endpoint.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.endpoint.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="describe_endpoints",
        op_kwargs={"MaxResults": max_results, "Mode": mode, "NextToken": next_token},
    )
