"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Associates an AWS Certificate Manager (ACM) Amazon Resource Name (ARN) with AWS Elemental MediaConvert.

    Args:
        arn(str): The ARN of the ACM certificate that you want to associate with your MediaConvert resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.certificate.associate(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.certificate.associate arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="associate_certificate",
        op_kwargs={"Arn": arn},
    )


async def disassociate(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and an AWS Elemental MediaConvert resource.

    Args:
        arn(str): The ARN of the ACM certificate that you want to disassociate from your MediaConvert resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconvert.certificate.disassociate(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconvert.certificate.disassociate arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconvert",
        operation="disassociate_certificate",
        op_kwargs={"Arn": arn},
    )
