"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: Dict) -> None:
    r"""
    **Autogenerated function**

    Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
        tags(Dict): A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.resource.tag(ctx, resource_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="tag_resource",
        op_kwargs={"ResourceArn": resource_arn, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Deletes specified tags from a resource.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource from which to delete tags.
        tag_keys(List): The keys of the tags to be removed.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.resource.untag(
                ctx, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="untag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagKeys": tag_keys},
    )
