"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, offering_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).

    Args:
        offering_arn(str): The Amazon Resource Name (ARN) of the offering.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.offering.describe(ctx, offering_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.offering.describe offering_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="describe_offering",
        op_kwargs={"OfferingArn": offering_arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Displays a list of all offerings that are available to this account in the current AWS Region. If you have an active reservation (which means you've purchased an offering that has already started and hasn't expired yet), your account isn't eligible for other offerings.

    Args:
        max_results(int, optional): The maximum number of results to return per API request. For example, you submit a ListOfferings request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page. Defaults to None.
        next_token(str, optional): The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.offering.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.offering.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="list_offerings",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def purchase(
    hub, ctx, offering_arn: str, reservation_name: str, start: str
) -> Dict:
    r"""
    **Autogenerated function**

    Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another offering.

    Args:
        offering_arn(str): The Amazon Resource Name (ARN) of the offering.
        reservation_name(str): The name that you want to use for the reservation.
        start(str): The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.offering.purchase(
                ctx, offering_arn=value, reservation_name=value, start=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.offering.purchase offering_arn=value, reservation_name=value, start=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="purchase_offering",
        op_kwargs={
            "OfferingArn": offering_arn,
            "ReservationName": reservation_name,
            "Start": start,
        },
    )
