"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, flow_arn: str, vpc_interfaces: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds VPC interfaces to flow

    Args:
        flow_arn(str): The flow that you want to mutate.
        vpc_interfaces(List): A list of VPC interfaces that you want to add.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.vpc_interface.add(
                ctx, flow_arn=value, vpc_interfaces=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.vpc_interface.add flow_arn=value, vpc_interfaces=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="add_flow_vpc_interfaces",
        op_kwargs={"FlowArn": flow_arn, "VpcInterfaces": vpc_interfaces},
    )


async def remove(hub, ctx, flow_arn: str, vpc_interface_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.

    Args:
        flow_arn(str): The flow that you want to remove a VPC interface from.
        vpc_interface_name(str): The name of the VPC interface that you want to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.vpc_interface.remove(
                ctx, flow_arn=value, vpc_interface_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.vpc_interface.remove flow_arn=value, vpc_interface_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="remove_flow_vpc_interface",
        op_kwargs={"FlowArn": flow_arn, "VpcInterfaceName": vpc_interface_name},
    )
