"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, flow_arn: str, sources: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds Sources to flow

    Args:
        flow_arn(str): The flow that you want to mutate.
        sources(List): A list of sources that you want to add.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.source.add(ctx, flow_arn=value, sources=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.source.add flow_arn=value, sources=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="add_flow_sources",
        op_kwargs={"FlowArn": flow_arn, "Sources": sources},
    )


async def remove(hub, ctx, flow_arn: str, source_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.

    Args:
        flow_arn(str): The flow that you want to remove a source from.
        source_arn(str): The ARN of the source that you want to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.source.remove(
                ctx, flow_arn=value, source_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.source.remove flow_arn=value, source_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="remove_flow_source",
        op_kwargs={"FlowArn": flow_arn, "SourceArn": source_arn},
    )


async def update(
    hub,
    ctx,
    flow_arn: str,
    source_arn: str,
    decryption: Dict = None,
    description: str = None,
    entitlement_arn: str = None,
    ingest_port: int = None,
    max_bitrate: int = None,
    max_latency: int = None,
    max_sync_buffer: int = None,
    media_stream_source_configurations: List = None,
    min_latency: int = None,
    protocol: str = None,
    stream_id: str = None,
    vpc_interface_name: str = None,
    whitelist_cidr: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the source of a flow.

    Args:
        decryption(Dict, optional): The type of encryption used on the content ingested from this source. Defaults to None.
        description(str, optional): A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account. Defaults to None.
        entitlement_arn(str, optional): The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow. Defaults to None.
        flow_arn(str): The flow that is associated with the source that you want to update.
        ingest_port(int, optional): The port that the flow will be listening on for incoming content. Defaults to None.
        max_bitrate(int, optional): The smoothing max bitrate for RIST, RTP, and RTP-FEC streams. Defaults to None.
        max_latency(int, optional): The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams. Defaults to None.
        max_sync_buffer(int, optional): The size of the buffer (in milliseconds) to use to sync incoming source data. Defaults to None.
        media_stream_source_configurations(List, optional): The media streams that are associated with the source, and the parameters for those associations. Defaults to None.
        min_latency(int, optional): The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency. Defaults to None.
        protocol(str, optional): The protocol that is used by the source. Defaults to None.
        source_arn(str): The ARN of the source that you want to update.
        stream_id(str, optional): The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams. Defaults to None.
        vpc_interface_name(str, optional): The name of the VPC interface to use for this source. Defaults to None.
        whitelist_cidr(str, optional): The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.source.update(
                ctx, flow_arn=value, source_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.source.update flow_arn=value, source_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="update_flow_source",
        op_kwargs={
            "Decryption": decryption,
            "Description": description,
            "EntitlementArn": entitlement_arn,
            "FlowArn": flow_arn,
            "IngestPort": ingest_port,
            "MaxBitrate": max_bitrate,
            "MaxLatency": max_latency,
            "MaxSyncBuffer": max_sync_buffer,
            "MediaStreamSourceConfigurations": media_stream_source_configurations,
            "MinLatency": min_latency,
            "Protocol": protocol,
            "SourceArn": source_arn,
            "StreamId": stream_id,
            "VpcInterfaceName": vpc_interface_name,
            "WhitelistCidr": whitelist_cidr,
        },
    )
