"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, flow_arn: str, outputs: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds outputs to an existing flow. You can create up to 50 outputs per flow.

    Args:
        flow_arn(str): The flow that you want to add outputs to.
        outputs(List): A list of outputs that you want to add.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.output.add(ctx, flow_arn=value, outputs=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.output.add flow_arn=value, outputs=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="add_flow_outputs",
        op_kwargs={"FlowArn": flow_arn, "Outputs": outputs},
    )


async def remove(hub, ctx, flow_arn: str, output_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.

    Args:
        flow_arn(str): The flow that you want to remove an output from.
        output_arn(str): The ARN of the output that you want to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.output.remove(
                ctx, flow_arn=value, output_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.output.remove flow_arn=value, output_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="remove_flow_output",
        op_kwargs={"FlowArn": flow_arn, "OutputArn": output_arn},
    )


async def update(
    hub,
    ctx,
    flow_arn: str,
    output_arn: str,
    cidr_allow_list: List = None,
    description: str = None,
    destination: str = None,
    encryption: Dict = None,
    max_latency: int = None,
    media_stream_output_configurations: List = None,
    min_latency: int = None,
    port: int = None,
    protocol: str = None,
    remote_id: str = None,
    smoothing_latency: int = None,
    stream_id: str = None,
    vpc_interface_attachment: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing flow output.

    Args:
        cidr_allow_list(List, optional): The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16. Defaults to None.
        description(str, optional): A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user. Defaults to None.
        destination(str, optional): The IP address where you want to send the output. Defaults to None.
        encryption(Dict, optional): The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key). Defaults to None.
        flow_arn(str): The flow that is associated with the output that you want to update.
        max_latency(int, optional): The maximum latency in milliseconds for Zixi-based streams. Defaults to None.
        media_stream_output_configurations(List, optional): The media streams that are associated with the output, and the parameters for those associations. Defaults to None.
        min_latency(int, optional): The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency. Defaults to None.
        output_arn(str): The ARN of the output that you want to update.
        port(int, optional): The port to use when content is distributed to this output. Defaults to None.
        protocol(str, optional): The protocol to use for the output. Defaults to None.
        remote_id(str, optional): The remote ID for the Zixi-pull stream. Defaults to None.
        smoothing_latency(int, optional): The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams. Defaults to None.
        stream_id(str, optional): The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams. Defaults to None.
        vpc_interface_attachment(Dict, optional): The name of the VPC interface attachment to use for this output. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.output.update(
                ctx, flow_arn=value, output_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.output.update flow_arn=value, output_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="update_flow_output",
        op_kwargs={
            "CidrAllowList": cidr_allow_list,
            "Description": description,
            "Destination": destination,
            "Encryption": encryption,
            "FlowArn": flow_arn,
            "MaxLatency": max_latency,
            "MediaStreamOutputConfigurations": media_stream_output_configurations,
            "MinLatency": min_latency,
            "OutputArn": output_arn,
            "Port": port,
            "Protocol": protocol,
            "RemoteId": remote_id,
            "SmoothingLatency": smoothing_latency,
            "StreamId": stream_id,
            "VpcInterfaceAttachment": vpc_interface_attachment,
        },
    )
