"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, flow_arn: str, media_streams: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.

    Args:
        flow_arn(str): The Amazon Resource Name (ARN) of the flow.
        media_streams(List): The media streams that you want to add to the flow.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.media_stream.add(
                ctx, flow_arn=value, media_streams=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.media_stream.add flow_arn=value, media_streams=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="add_flow_media_streams",
        op_kwargs={"FlowArn": flow_arn, "MediaStreams": media_streams},
    )


async def remove(hub, ctx, flow_arn: str, media_stream_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.

    Args:
        flow_arn(str): The Amazon Resource Name (ARN) of the flow.
        media_stream_name(str): The name of the media stream that you want to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.media_stream.remove(
                ctx, flow_arn=value, media_stream_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.media_stream.remove flow_arn=value, media_stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="remove_flow_media_stream",
        op_kwargs={"FlowArn": flow_arn, "MediaStreamName": media_stream_name},
    )


async def update(
    hub,
    ctx,
    flow_arn: str,
    media_stream_name: str,
    attributes: Dict = None,
    clock_rate: int = None,
    description: str = None,
    media_stream_type: str = None,
    video_format: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing media stream.

    Args:
        attributes(Dict, optional): The attributes that you want to assign to the media stream. Defaults to None.
        clock_rate(int, optional): The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000. Defaults to None.
        description(str, optional): Description. Defaults to None.
        flow_arn(str): The Amazon Resource Name (ARN) of the flow.
        media_stream_name(str): The name of the media stream that you want to update.
        media_stream_type(str, optional): The type of media stream. Defaults to None.
        video_format(str, optional): The resolution of the video. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.media_stream.update(
                ctx, flow_arn=value, media_stream_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.media_stream.update flow_arn=value, media_stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="update_flow_media_stream",
        op_kwargs={
            "Attributes": attributes,
            "ClockRate": clock_rate,
            "Description": description,
            "FlowArn": flow_arn,
            "MediaStreamName": media_stream_name,
            "MediaStreamType": media_stream_type,
            "VideoFormat": video_format,
        },
    )
