"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    availability_zone: str = None,
    entitlements: List = None,
    media_streams: List = None,
    outputs: List = None,
    source: Dict = None,
    source_failover_config: Dict = None,
    sources: List = None,
    vpc_interfaces: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).

    Args:
        availability_zone(str, optional): The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region. Defaults to None.
        entitlements(List, optional): The entitlements that you want to grant on a flow. Defaults to None.
        media_streams(List, optional): The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow. Defaults to None.
        name(str): The name of the flow.
        outputs(List, optional): The outputs that you want to add to this flow. Defaults to None.
        source(Dict, optional): The settings for the source of the flow. Defaults to None.
        source_failover_config(Dict, optional): The settings for source failover. Defaults to None.
        sources(List, optional): . Defaults to None.
        vpc_interfaces(List, optional): The VPC interfaces you want on the flow. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="create_flow",
        op_kwargs={
            "AvailabilityZone": availability_zone,
            "Entitlements": entitlements,
            "MediaStreams": media_streams,
            "Name": name,
            "Outputs": outputs,
            "Source": source,
            "SourceFailoverConfig": source_failover_config,
            "Sources": sources,
            "VpcInterfaces": vpc_interfaces,
        },
    )


async def delete(hub, ctx, flow_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a flow. Before you can delete a flow, you must stop the flow.

    Args:
        flow_arn(str): The ARN of the flow that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.init.delete(ctx, flow_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.init.delete flow_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="delete_flow",
        op_kwargs={"FlowArn": flow_arn},
    )


async def describe(hub, ctx, flow_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays the details of a flow. The response includes the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.

    Args:
        flow_arn(str): The ARN of the flow that you want to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.init.describe(ctx, flow_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.init.describe flow_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="describe_flow",
        op_kwargs={"FlowArn": flow_arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Displays a list of flows that are associated with this account. This request returns a paginated result.

    Args:
        max_results(int, optional): The maximum number of results to return per API request. For example, you submit a ListFlows request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page. Defaults to None.
        next_token(str, optional): The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="list_flows",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def start(hub, ctx, flow_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts a flow.

    Args:
        flow_arn(str): The ARN of the flow that you want to start.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.init.start(ctx, flow_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.init.start flow_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="start_flow",
        op_kwargs={"FlowArn": flow_arn},
    )


async def stop(hub, ctx, flow_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a flow.

    Args:
        flow_arn(str): The ARN of the flow that you want to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.init.stop(ctx, flow_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.init.stop flow_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="stop_flow",
        op_kwargs={"FlowArn": flow_arn},
    )


async def update(hub, ctx, flow_arn: str, source_failover_config: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates flow

    Args:
        flow_arn(str): The flow that you want to update.
        source_failover_config(Dict, optional): The settings for source failover. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.init.update(ctx, flow_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.init.update flow_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="update_flow",
        op_kwargs={"FlowArn": flow_arn, "SourceFailoverConfig": source_failover_config},
    )
