"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def grant(hub, ctx, entitlements: List, flow_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Grants entitlements to an existing flow.

    Args:
        entitlements(List): The list of entitlements that you want to grant.
        flow_arn(str): The flow that you want to grant entitlements on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.entitlement.grant(
                ctx, entitlements=value, flow_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.entitlement.grant entitlements=value, flow_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="grant_flow_entitlements",
        op_kwargs={"Entitlements": entitlements, "FlowArn": flow_arn},
    )


async def revoke(hub, ctx, entitlement_arn: str, flow_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.

    Args:
        entitlement_arn(str): The ARN of the entitlement that you want to revoke.
        flow_arn(str): The flow that you want to revoke an entitlement from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.entitlement.revoke(
                ctx, entitlement_arn=value, flow_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.entitlement.revoke entitlement_arn=value, flow_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="revoke_flow_entitlement",
        op_kwargs={"EntitlementArn": entitlement_arn, "FlowArn": flow_arn},
    )


async def update(
    hub,
    ctx,
    entitlement_arn: str,
    flow_arn: str,
    description: str = None,
    encryption: Dict = None,
    entitlement_status: str = None,
    subscribers: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    You can change an entitlement's description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.

    Args:
        description(str, optional): A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user. Defaults to None.
        encryption(Dict, optional): The type of encryption that will be used on the output associated with this entitlement. Defaults to None.
        entitlement_arn(str): The ARN of the entitlement that you want to update.
        entitlement_status(str, optional): An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged. Defaults to None.
        flow_arn(str): The flow that is associated with the entitlement that you want to update.
        subscribers(List, optional): The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.mediaconnect.flow.entitlement.update(
                ctx, entitlement_arn=value, flow_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.mediaconnect.flow.entitlement.update entitlement_arn=value, flow_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="mediaconnect",
        operation="update_flow_entitlement",
        op_kwargs={
            "Description": description,
            "Encryption": encryption,
            "EntitlementArn": entitlement_arn,
            "EntitlementStatus": entitlement_status,
            "FlowArn": flow_arn,
            "Subscribers": subscribers,
        },
    )
