"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def start(
    hub,
    ctx,
    data_set_type: str,
    from_date: str,
    role_name_arn: str,
    destination_s3_bucket_name: str,
    sns_topic_arn: str,
    destination_s3_prefix: str = None,
    customer_defined_values: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Given a data set type and a from date, asynchronously publishes the requested customer support data to the specified S3 bucket and notifies the specified SNS topic once the data is available. Returns a unique request identifier that can be used to correlate requests with notifications from the SNS topic. Data sets will be published in comma-separated values (CSV) format with the file name {data_set_type}_YYYY-MM-DD'T'HH-mm-ss'Z'.csv. If a file with the same name already exists (e.g. if the same data set is requested twice), the original file will be overwritten by the new file. Requires a Role with an attached permissions policy providing Allow permissions for the following actions: s3:PutObject, s3:GetBucketLocation, sns:GetTopicAttributes, sns:Publish, iam:GetRolePolicy.

    Args:
        data_set_type(str):  Specifies the data set type to be written to the output csv file. The data set types customer_support_contacts_data and test_customer_support_contacts_data both result in a csv file containing the following fields: Product Id, Product Code, Customer Guid, Subscription Guid, Subscription Start Date, Organization, AWS Account Id, Given Name, Surname, Telephone Number, Email, Title, Country Code, ZIP Code, Operation Type, and Operation Time.    customer_support_contacts_data Customer support contact data. The data set will contain all changes (Creates, Updates, and Deletes) to customer support contact data from the date specified in the from_date parameter. test_customer_support_contacts_data An example data set containing static test data in the same format as customer_support_contacts_data  .
        from_date(str): The start date from which to retrieve the data set in UTC. This parameter only affects the customer_support_contacts_data data set type.
        role_name_arn(str): The Amazon Resource Name (ARN) of the Role with an attached permissions policy to interact with the provided AWS services.
        destination_s3_bucket_name(str): The name (friendly name, not ARN) of the destination S3 bucket.
        destination_s3_prefix(str, optional): (Optional) The desired S3 prefix for the published data set, similar to a directory path in standard file systems. For example, if given the bucket name "mybucket" and the prefix "myprefix/mydatasets", the output file "outputfile" would be published to "s3://mybucket/myprefix/mydatasets/outputfile". If the prefix directory structure does not exist, it will be created. If no prefix is provided, the data set will be published to the S3 bucket root. Defaults to None.
        sns_topic_arn(str): Amazon Resource Name (ARN) for the SNS Topic that will be notified when the data set has been published or if an error has occurred.
        customer_defined_values(Dict, optional): (Optional) Key-value pairs which will be returned, unmodified, in the Amazon SNS notification message and the data set metadata file. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.marketplacecommerceanalytic.support_data_export.start(
                ctx,
                data_set_type=value,
                from_date=value,
                role_name_arn=value,
                destination_s3_bucket_name=value,
                sns_topic_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.marketplacecommerceanalytic.support_data_export.start data_set_type=value, from_date=value, role_name_arn=value, destination_s3_bucket_name=value, sns_topic_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="marketplacecommerceanalytics",
        operation="start_support_data_export",
        op_kwargs={
            "dataSetType": data_set_type,
            "fromDate": from_date,
            "roleNameArn": role_name_arn,
            "destinationS3BucketName": destination_s3_bucket_name,
            "destinationS3Prefix": destination_s3_prefix,
            "snsTopicArn": sns_topic_arn,
            "customerDefinedValues": customer_defined_values,
        },
    )
