"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    product_code: str,
    filter_: Dict = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    GetEntitlements retrieves entitlement values for a given product. The results can be filtered based on customer identifier or product dimensions.

    Args:
        product_code(str): Product code is used to uniquely identify a product in AWS Marketplace. The product code will be provided by AWS Marketplace when the product listing is created.
        filter_(Dict, optional): Filter is used to return entitlements for a specific customer or for a specific dimension. Filters are described as keys mapped to a lists of values. Filtered requests are unioned for each value in the value list, and then intersected for each filter key. Defaults to None.
        next_token(str, optional): For paginated calls to GetEntitlements, pass the NextToken from the previous GetEntitlementsResult. Defaults to None.
        max_results(int, optional): The maximum number of items to retrieve from the GetEntitlements operation. For pagination, use the NextToken field in subsequent calls to GetEntitlements. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.marketplace_entitlement_entitlement.get_all(
                ctx, product_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.marketplace_entitlement_entitlement.get_all product_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="marketplace-entitlement",
        operation="get_entitlements",
        op_kwargs={
            "ProductCode": product_code,
            "Filter": filter_,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
