"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "change_set"


async def cancel(hub, ctx, catalog: str, change_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Used to cancel an open change request. Must be sent before the status of the request changes to APPLYING, the final stage of completing your change request. You can describe a change during the 60-day request history retention period for API calls.

    Args:
        catalog(str): Required. The catalog related to the request. Fixed value: AWSMarketplace.
        change_set_id(str): Required. The unique identifier of the StartChangeSet request that you want to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.marketplace_catalog.change_set_.cancel(
                ctx, catalog=value, change_set_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.marketplace_catalog.change_set.cancel catalog=value, change_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="marketplace-catalog",
        operation="cancel_change_set",
        op_kwargs={"Catalog": catalog, "ChangeSetId": change_set_id},
    )


async def describe(hub, ctx, catalog: str, change_set_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides information about a given change set.

    Args:
        catalog(str): Required. The catalog related to the request. Fixed value: AWSMarketplace .
        change_set_id(str): Required. The unique identifier for the StartChangeSet request that you want to describe the details for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.marketplace_catalog.change_set_.describe(
                ctx, catalog=value, change_set_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.marketplace_catalog.change_set.describe catalog=value, change_set_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="marketplace-catalog",
        operation="describe_change_set",
        op_kwargs={"Catalog": catalog, "ChangeSetId": change_set_id},
    )


async def list_all(
    hub,
    ctx,
    catalog: str,
    filter_list: List = None,
    sort: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of change sets owned by the account being used to make the call. You can filter this list by providing any combination of entityId, ChangeSetName, and status. If you provide more than one filter, the API operation applies a logical AND between the filters. You can describe a change during the 60-day request history retention period for API calls.

    Args:
        catalog(str): The catalog related to the request. Fixed value: AWSMarketplace .
        filter_list(List, optional): An array of filter objects. Defaults to None.
        sort(Dict, optional): An object that contains two attributes, SortBy and SortOrder. Defaults to None.
        max_results(int, optional): The maximum number of results returned by a single call. This value must be provided in the next call to retrieve the next set of results. By default, this value is 20. Defaults to None.
        next_token(str, optional): The token value retrieved from a previous call to access the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.marketplace_catalog.change_set_.list_all(ctx, catalog=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.marketplace_catalog.change_set.list_all catalog=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="marketplace-catalog",
        operation="list_change_sets",
        op_kwargs={
            "Catalog": catalog,
            "FilterList": filter_list,
            "Sort": sort,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def start(
    hub,
    ctx,
    catalog: str,
    change_set: List,
    change_set_name: str = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation allows you to request changes for your entities. Within a single ChangeSet, you cannot start the same change type against the same entity multiple times. Additionally, when a ChangeSet is running, all the entities targeted by the different changes are locked until the ChangeSet has completed (either succeeded, cancelled, or failed). If you try to start a ChangeSet containing a change against an entity that is already locked, you will receive a ResourceInUseException. For example, you cannot start the ChangeSet described in the example later in this topic, because it contains two changes to execute the same change type (AddRevisions) against the same entity (entity-id@1). For more information about working with change sets, see  Working with change sets.

    Args:
        catalog(str): The catalog related to the request. Fixed value: AWSMarketplace .
        change_set(List): Array of change object.
        change_set_name(str, optional): Optional case sensitive string of up to 100 ASCII characters. The change set name can be used to filter the list of change sets. . Defaults to None.
        client_request_token(str, optional): A unique token to identify the request to ensure idempotency. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.marketplace_catalog.change_set_.start(
                ctx, catalog=value, change_set=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.marketplace_catalog.change_set.start catalog=value, change_set=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="marketplace-catalog",
        operation="start_change_set",
        op_kwargs={
            "Catalog": catalog,
            "ChangeSet": change_set,
            "ChangeSetName": change_set_name,
            "ClientRequestToken": client_request_token,
        },
    )
