"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    network_id: str,
    proposal_id: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of the member that cast the vote. Applies only to Hyperledger Fabric.

    Args:
        network_id(str):  The unique identifier of the network. .
        proposal_id(str):  The unique identifier of the proposal. .
        max_results(int, optional):  The maximum number of votes to return. . Defaults to None.
        next_token(str, optional):  The pagination token that indicates the next set of results to retrieve. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.proposal.vote.list_all(
                ctx, network_id=value, proposal_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.proposal.vote.list_all network_id=value, proposal_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="list_proposal_votes",
        op_kwargs={
            "NetworkId": network_id,
            "ProposalId": proposal_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
