"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    client_request_token: str,
    network_id: str,
    member_id: str,
    actions: Dict,
    description: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a proposal for a change to the network that other members of the network can vote on, for example, a proposal to add a new member to the network. Any member can create a proposal. Applies only to Hyperledger Fabric.

    Args:
        client_request_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.
        network_id(str):  The unique identifier of the network for which the proposal is made.
        member_id(str): The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single AWS account.
        actions(Dict): The type of actions proposed, such as inviting a member or removing a member. The types of Actions in a proposal are mutually exclusive. For example, a proposal with Invitations actions cannot also contain Removals actions.
        description(str, optional): A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member.". Defaults to None.
        tags(Dict, optional): Tags to assign to the proposal. Each tag consists of a key and optional value. When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. If the proposal is for a network invitation, the invitation inherits the tags added to the proposal. For more information about tags, see Tagging Resources in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.proposal.init.create(
                ctx, client_request_token=value, network_id=value, member_id=value, actions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.proposal.init.create client_request_token=value, network_id=value, member_id=value, actions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="create_proposal",
        op_kwargs={
            "ClientRequestToken": client_request_token,
            "NetworkId": network_id,
            "MemberId": member_id,
            "Actions": actions,
            "Description": description,
            "Tags": tags,
        },
    )


async def get(hub, ctx, network_id: str, proposal_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns detailed information about a proposal. Applies only to Hyperledger Fabric.

    Args:
        network_id(str): The unique identifier of the network for which the proposal is made.
        proposal_id(str): The unique identifier of the proposal.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.proposal.init.get(
                ctx, network_id=value, proposal_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.proposal.init.get network_id=value, proposal_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="get_proposal",
        op_kwargs={"NetworkId": network_id, "ProposalId": proposal_id},
    )


async def list_all(
    hub, ctx, network_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of proposals for the network. Applies only to Hyperledger Fabric.

    Args:
        network_id(str):  The unique identifier of the network. .
        max_results(int, optional):  The maximum number of proposals to return. . Defaults to None.
        next_token(str, optional):  The pagination token that indicates the next set of results to retrieve. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.proposal.init.list_all(ctx, network_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.proposal.init.list_all network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="list_proposals",
        op_kwargs={
            "NetworkId": network_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
