"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def vote(
    hub, ctx, network_id: str, proposal_id: str, voter_member_id: str, vote: str
) -> Dict:
    r"""
    **Autogenerated function**

    Casts a vote for a specified ProposalId on behalf of a member. The member to vote as, specified by VoterMemberId, must be in the same AWS account as the principal that calls the action. Applies only to Hyperledger Fabric.

    Args:
        network_id(str):  The unique identifier of the network. .
        proposal_id(str):  The unique identifier of the proposal. .
        voter_member_id(str): The unique identifier of the member casting the vote. .
        vote(str):  The value of the vote. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.on_proposal.vote(
                ctx, network_id=value, proposal_id=value, voter_member_id=value, vote=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.on_proposal.vote network_id=value, proposal_id=value, voter_member_id=value, vote=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="vote_on_proposal",
        op_kwargs={
            "NetworkId": network_id,
            "ProposalId": proposal_id,
            "VoterMemberId": voter_member_id,
            "Vote": vote,
        },
    )
