"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    client_request_token: str,
    network_id: str,
    node_configuration: Dict,
    member_id: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a node on the specified blockchain network. Applies to Hyperledger Fabric and Ethereum.

    Args:
        client_request_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.
        network_id(str): The unique identifier of the network for the node. Ethereum public networks have the following NetworkIds:    n-ethereum-mainnet     n-ethereum-rinkeby     n-ethereum-ropsten   .
        member_id(str, optional): The unique identifier of the member that owns this node. Applies only to Hyperledger Fabric. Defaults to None.
        node_configuration(Dict): The properties of a node configuration.
        tags(Dict, optional): Tags to assign to the node. Each tag consists of a key and optional value. When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. For more information about tags, see Tagging Resources in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.node.create(
                ctx, client_request_token=value, network_id=value, node_configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.node.create client_request_token=value, network_id=value, node_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="create_node",
        op_kwargs={
            "ClientRequestToken": client_request_token,
            "NetworkId": network_id,
            "MemberId": member_id,
            "NodeConfiguration": node_configuration,
            "Tags": tags,
        },
    )


async def delete(
    hub, ctx, network_id: str, node_id: str, member_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a node that your AWS account owns. All data on the node is lost and cannot be recovered. Applies to Hyperledger Fabric and Ethereum.

    Args:
        network_id(str): The unique identifier of the network that the node is on. Ethereum public networks have the following NetworkIds:    n-ethereum-mainnet     n-ethereum-rinkeby     n-ethereum-ropsten   .
        member_id(str, optional): The unique identifier of the member that owns this node. Applies only to Hyperledger Fabric and is required for Hyperledger Fabric. Defaults to None.
        node_id(str): The unique identifier of the node.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.node.delete(
                ctx, network_id=value, node_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.node.delete network_id=value, node_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="delete_node",
        op_kwargs={"NetworkId": network_id, "MemberId": member_id, "NodeId": node_id},
    )


async def get(hub, ctx, network_id: str, node_id: str, member_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns detailed information about a node. Applies to Hyperledger Fabric and Ethereum.

    Args:
        network_id(str): The unique identifier of the network that the node is on.
        member_id(str, optional): The unique identifier of the member that owns the node. Applies only to Hyperledger Fabric and is required for Hyperledger Fabric. Defaults to None.
        node_id(str): The unique identifier of the node.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.node.get(ctx, network_id=value, node_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.node.get network_id=value, node_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="get_node",
        op_kwargs={"NetworkId": network_id, "MemberId": member_id, "NodeId": node_id},
    )


async def list_all(
    hub,
    ctx,
    network_id: str,
    member_id: str = None,
    status: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the nodes within a network. Applies to Hyperledger Fabric and Ethereum.

    Args:
        network_id(str): The unique identifier of the network for which to list nodes.
        member_id(str, optional): The unique identifier of the member who owns the nodes to list. Applies only to Hyperledger Fabric and is required for Hyperledger Fabric. Defaults to None.
        status(str, optional): An optional status specifier. If provided, only nodes currently in this status are listed. Defaults to None.
        max_results(int, optional): The maximum number of nodes to list. Defaults to None.
        next_token(str, optional): The pagination token that indicates the next set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.node.list_all(ctx, network_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.node.list_all network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="list_nodes",
        op_kwargs={
            "NetworkId": network_id,
            "MemberId": member_id,
            "Status": status,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    network_id: str,
    node_id: str,
    member_id: str = None,
    log_publishing_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a node configuration with new parameters. Applies only to Hyperledger Fabric.

    Args:
        network_id(str): The unique identifier of the network that the node is on.
        member_id(str, optional): The unique identifier of the member that owns the node. Applies only to Hyperledger Fabric. Defaults to None.
        node_id(str): The unique identifier of the node.
        log_publishing_configuration(Dict, optional): Configuration properties for publishing to Amazon CloudWatch Logs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.node.update(
                ctx, network_id=value, node_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.node.update network_id=value, node_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="update_node",
        op_kwargs={
            "NetworkId": network_id,
            "MemberId": member_id,
            "NodeId": node_id,
            "LogPublishingConfiguration": log_publishing_configuration,
        },
    )
