"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    client_request_token: str,
    name: str,
    framework: str,
    framework_version: str,
    voting_policy: Dict,
    member_configuration: Dict,
    description: str = None,
    framework_configuration: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new blockchain network using Amazon Managed Blockchain. Applies only to Hyperledger Fabric.

    Args:
        client_request_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.
        name(str): The name of the network.
        description(str, optional): An optional description for the network. Defaults to None.
        framework(str): The blockchain framework that the network uses.
        framework_version(str): The version of the blockchain framework that the network uses.
        framework_configuration(Dict, optional):  Configuration properties of the blockchain framework relevant to the network configuration. . Defaults to None.
        voting_policy(Dict):  The voting rules used by the network to determine if a proposal is approved. .
        member_configuration(Dict): Configuration properties for the first member within the network.
        tags(Dict, optional): Tags to assign to the network. Each tag consists of a key and optional value. When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. For more information about tags, see Tagging Resources in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.network.create(
                ctx,
                client_request_token=value,
                name=value,
                framework=value,
                framework_version=value,
                voting_policy=value,
                member_configuration=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.network.create client_request_token=value, name=value, framework=value, framework_version=value, voting_policy=value, member_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="create_network",
        op_kwargs={
            "ClientRequestToken": client_request_token,
            "Name": name,
            "Description": description,
            "Framework": framework,
            "FrameworkVersion": framework_version,
            "FrameworkConfiguration": framework_configuration,
            "VotingPolicy": voting_policy,
            "MemberConfiguration": member_configuration,
            "Tags": tags,
        },
    )


async def get(hub, ctx, network_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns detailed information about a network. Applies to Hyperledger Fabric and Ethereum.

    Args:
        network_id(str): The unique identifier of the network to get information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.network.get(ctx, network_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.network.get network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="get_network",
        op_kwargs={"NetworkId": network_id},
    )


async def list_all(
    hub,
    ctx,
    name: str = None,
    framework: str = None,
    status: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the networks in which the current AWS account participates. Applies to Hyperledger Fabric and Ethereum.

    Args:
        name(str, optional): The name of the network. Defaults to None.
        framework(str, optional): An optional framework specifier. If provided, only networks of this framework type are listed. Defaults to None.
        status(str, optional): An optional status specifier. If provided, only networks currently in this status are listed. Applies only to Hyperledger Fabric. Defaults to None.
        max_results(int, optional): The maximum number of networks to list. Defaults to None.
        next_token(str, optional): The pagination token that indicates the next set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.network.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.network.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="list_networks",
        op_kwargs={
            "Name": name,
            "Framework": framework,
            "Status": status,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
