"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    client_request_token: str,
    invitation_id: str,
    network_id: str,
    member_configuration: Dict,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a member within a Managed Blockchain network. Applies only to Hyperledger Fabric.

    Args:
        client_request_token(str): A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.
        invitation_id(str): The unique identifier of the invitation that is sent to the member to join the network.
        network_id(str): The unique identifier of the network in which the member is created.
        member_configuration(Dict): Member configuration parameters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.member.create(
                ctx,
                client_request_token=value,
                invitation_id=value,
                network_id=value,
                member_configuration=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.member.create client_request_token=value, invitation_id=value, network_id=value, member_configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="create_member",
        op_kwargs={
            "ClientRequestToken": client_request_token,
            "InvitationId": invitation_id,
            "NetworkId": network_id,
            "MemberConfiguration": member_configuration,
        },
    )


async def delete(hub, ctx, network_id: str, member_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a member. Deleting a member removes the member and all associated resources from the network. DeleteMember can only be called for a specified MemberId if the principal performing the action is associated with the AWS account that owns the member. In all other cases, the DeleteMember action is carried out as the result of an approved proposal to remove a member. If MemberId is the last member in a network specified by the last AWS account, the network is deleted also. Applies only to Hyperledger Fabric.

    Args:
        network_id(str): The unique identifier of the network from which the member is removed.
        member_id(str): The unique identifier of the member to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.member.delete(
                ctx, network_id=value, member_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.member.delete network_id=value, member_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="delete_member",
        op_kwargs={"NetworkId": network_id, "MemberId": member_id},
    )


async def get(hub, ctx, network_id: str, member_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns detailed information about a member. Applies only to Hyperledger Fabric.

    Args:
        network_id(str): The unique identifier of the network to which the member belongs.
        member_id(str): The unique identifier of the member.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.member.get(
                ctx, network_id=value, member_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.member.get network_id=value, member_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="get_member",
        op_kwargs={"NetworkId": network_id, "MemberId": member_id},
    )


async def list_all(
    hub,
    ctx,
    network_id: str,
    name: str = None,
    status: str = None,
    is_owned: bool = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the members in a network and properties of their configurations. Applies only to Hyperledger Fabric.

    Args:
        network_id(str): The unique identifier of the network for which to list members.
        name(str, optional): The optional name of the member to list. Defaults to None.
        status(str, optional): An optional status specifier. If provided, only members currently in this status are listed. Defaults to None.
        is_owned(bool, optional): An optional Boolean value. If provided, the request is limited either to members that the current AWS account owns (true) or that other AWS accounts own (false). If omitted, all members are listed. Defaults to None.
        max_results(int, optional): The maximum number of members to return in the request. Defaults to None.
        next_token(str, optional): The pagination token that indicates the next set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.member.list_all(ctx, network_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.member.list_all network_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="list_members",
        op_kwargs={
            "NetworkId": network_id,
            "Name": name,
            "Status": status,
            "IsOwned": is_owned,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub, ctx, network_id: str, member_id: str, log_publishing_configuration: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a member configuration with new parameters. Applies only to Hyperledger Fabric.

    Args:
        network_id(str): The unique identifier of the Managed Blockchain network to which the member belongs.
        member_id(str): The unique identifier of the member.
        log_publishing_configuration(Dict, optional): Configuration properties for publishing to Amazon CloudWatch Logs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.member.update(
                ctx, network_id=value, member_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.member.update network_id=value, member_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="update_member",
        op_kwargs={
            "NetworkId": network_id,
            "MemberId": member_id,
            "LogPublishingConfiguration": log_publishing_configuration,
        },
    )
