"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all invitations for the current AWS account. Applies only to Hyperledger Fabric.

    Args:
        max_results(int, optional): The maximum number of invitations to return. Defaults to None.
        next_token(str, optional): The pagination token that indicates the next set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.invitation.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.invitation.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="list_invitations",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def reject(hub, ctx, invitation_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Rejects an invitation to join a network. This action can be called by a principal in an AWS account that has received an invitation to create a member and join a network. Applies only to Hyperledger Fabric.

    Args:
        invitation_id(str): The unique identifier of the invitation to reject.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.managedblockchain.invitation.reject(ctx, invitation_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.managedblockchain.invitation.reject invitation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="managedblockchain",
        operation="reject_invitation",
        op_kwargs={"InvitationId": invitation_id},
    )
