"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, time_range: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves (queries) aggregated usage data for an account.

    Args:
        time_range(str, optional): The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for this parameter, Amazon Macie provides aggregated usage data for the preceding 30 days. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.usage.total.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.usage.total.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="get_usage_totals",
        op_kwargs={"timeRange": time_range},
    )
