"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    filter_by: List = None,
    max_results: int = None,
    next_token: str = None,
    sort_by: Dict = None,
    time_range: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves (queries) quotas and aggregated usage data for one or more accounts.

    Args:
        filter_by(List, optional): An array of objects, one for each condition to use to filter the query results. If you specify more than one condition, Amazon Macie uses an AND operator to join the conditions. Defaults to None.
        max_results(int, optional): The maximum number of items to include in each page of the response. Defaults to None.
        next_token(str, optional): The nextToken string that specifies which page of results to return in a paginated response. Defaults to None.
        sort_by(Dict, optional): The criteria to use to sort the query results. Defaults to None.
        time_range(str, optional): The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie provides usage data for the preceding 30 days. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.usage.statistic.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.usage.statistic.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="get_usage_statistics",
        op_kwargs={
            "filterBy": filter_by,
            "maxResults": max_results,
            "nextToken": next_token,
            "sortBy": sort_by,
            "timeRange": time_range,
        },
    )
