"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(hub, ctx, finding_types: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates sample findings.

    Args:
        finding_types(List, optional): An array that lists one or more types of findings to include in the set of sample findings. Currently, the only supported value is Policy:IAMUser/S3BucketEncryptionDisabled. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.sample_finding.create_multiple(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.sample_finding.create_multiple
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="create_sample_findings",
        op_kwargs={"findingTypes": finding_types},
    )
