"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def search(
    hub,
    ctx,
    bucket_criteria: Dict = None,
    max_results: int = None,
    next_token: str = None,
    sort_criteria: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes.

    Args:
        bucket_criteria(Dict, optional): The filter conditions that determine which S3 buckets to include or exclude from the query results. Defaults to None.
        max_results(int, optional): The maximum number of items to include in each page of the response. The default value is 50. Defaults to None.
        next_token(str, optional): The nextToken string that specifies which page of results to return in a paginated response. Defaults to None.
        sort_criteria(Dict, optional): The criteria to use to sort the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.resource.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.resource.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="search_resources",
        op_kwargs={
            "bucketCriteria": bucket_criteria,
            "maxResults": max_results,
            "nextToken": next_token,
            "sortCriteria": sort_criteria,
        },
    )


async def tag(hub, ctx, resource_arn: str, tags: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds or updates one or more tags (keys and values) that are associated with a classification job, custom data identifier, findings filter, or member account.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.
        tags(Dict): A map of key-value pairs that specifies the tags to associate with the resource. A resource can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.resource.tag(ctx, resource_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="tag_resource",
        op_kwargs={"resourceArn": resource_arn, "tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes one or more tags (keys and values) from a classification job, custom data identifier, findings filter, or member account.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.
        tag_keys(List): The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.resource.untag(ctx, resource_arn=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="untag_resource",
        op_kwargs={"resourceArn": resource_arn, "tagKeys": tag_keys},
    )
