"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the Amazon Macie configuration settings for an Amazon Web Services organization.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.organization.configuration.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.organization.configuration.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="describe_organization_configuration",
        op_kwargs={},
    )


async def update(hub, ctx, auto_enable: bool) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Amazon Macie configuration settings for an Amazon Web Services organization.

    Args:
        auto_enable(bool): Specifies whether to enable Amazon Macie automatically for each account, when the account is added to the Amazon Web Services organization.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.organization.configuration.update(ctx, auto_enable=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.organization.configuration.update auto_enable=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="update_organization_configuration",
        op_kwargs={"autoEnable": auto_enable},
    )
