"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, admin_account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables an account as the delegated Amazon Macie administrator account for an Amazon Web Services organization.

    Args:
        admin_account_id(str): The Amazon Web Services account ID of the delegated Amazon Macie administrator account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.organization.admin_account.disable(
                ctx, admin_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.organization.admin_account.disable admin_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="disable_organization_admin_account",
        op_kwargs={"adminAccountId": admin_account_id},
    )


async def enable(hub, ctx, admin_account_id: str, client_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Designates an account as the delegated Amazon Macie administrator account for an Amazon Web Services organization.

    Args:
        admin_account_id(str): The Amazon Web Services account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.
        client_token(str, optional): A unique, case-sensitive token that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.organization.admin_account.enable(
                ctx, admin_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.organization.admin_account.enable admin_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="enable_organization_admin_account",
        op_kwargs={"adminAccountId": admin_account_id, "clientToken": client_token},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the delegated Amazon Macie administrator account for an Amazon Web Services organization.

    Args:
        max_results(int, optional): The maximum number of items to include in each page of a paginated response. Defaults to None.
        next_token(str, optional): The nextToken string that specifies which page of results to return in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.organization.admin_account.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.organization.admin_account.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="list_organization_admin_accounts",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )
