"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, id_: str, status: str) -> Dict:
    r"""
    **Autogenerated function**

    Enables an Amazon Macie administrator to suspend or re-enable a member account.

    Args:
        id_(str): The unique identifier for the Amazon Macie resource or account that the request applies to.
        status(str): Specifies the new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.member.session.update(ctx, id_=value, status=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.member.session.update id_=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="update_member_session",
        op_kwargs={"id": id_, "status": status},
    )
