"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, account: Dict, tags: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Associates an account with an Amazon Macie administrator account.

    Args:
        account(Dict): The details of the account to associate with the administrator account.
        tags(Dict, optional): A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie. An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.member.init.create(ctx, account=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.member.init.create account=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="create_member",
        op_kwargs={"account": account, "tags": tags},
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the association between an Amazon Macie administrator account and an account.

    Args:
        id_(str): The unique identifier for the Amazon Macie resource or account that the request applies to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.member.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.member.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="macie2", operation="delete_member", op_kwargs={"id": id_}
    )


async def disassociate(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates an Amazon Macie administrator account from a member account.

    Args:
        id_(str): The unique identifier for the Amazon Macie resource or account that the request applies to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.member.init.disassociate(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.member.init.disassociate id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="disassociate_member",
        op_kwargs={"id": id_},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about an account that's associated with an Amazon Macie administrator account.

    Args:
        id_(str): The unique identifier for the Amazon Macie resource or account that the request applies to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.member.init.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.member.init.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="macie2", operation="get_member", op_kwargs={"id": id_}
    )


async def list_all(
    hub,
    ctx,
    max_results: int = None,
    next_token: str = None,
    only_associated: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the accounts that are associated with an Amazon Macie administrator account.

    Args:
        max_results(int, optional): The maximum number of items to include in each page of a paginated response. Defaults to None.
        next_token(str, optional): The nextToken string that specifies which page of results to return in a paginated response. Defaults to None.
        only_associated(str, optional): Specifies which accounts to include in the response, based on the status of an account's relationship with the administrator account. By default, the response includes only current member accounts. To include all accounts, set this value to false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.member.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.member.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="list_members",
        op_kwargs={
            "maxResults": max_results,
            "nextToken": next_token,
            "onlyAssociated": only_associated,
        },
    )
