"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the current status and configuration settings for an Amazon Macie account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.macie.session.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.macie.session.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="macie2", operation="get_macie_session", op_kwargs={}
    )


async def update(
    hub, ctx, finding_publishing_frequency: str = None, status: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Suspends or re-enables an Amazon Macie account, or updates the configuration settings for a Macie account.

    Args:
        finding_publishing_frequency(str, optional): Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events). Defaults to None.
        status(str, optional): Specifies a new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.macie.session.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.macie.session.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="update_macie_session",
        op_kwargs={
            "findingPublishingFrequency": finding_publishing_frequency,
            "status": status,
        },
    )
