"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Disables an Amazon Macie account and deletes Macie resources for the account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.macie.init.disable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.macie.init.disable
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="macie2", operation="disable_macie", op_kwargs={}
    )


async def enable(
    hub,
    ctx,
    client_token: str = None,
    finding_publishing_frequency: str = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Enables Amazon Macie and specifies the configuration settings for a Macie account.

    Args:
        client_token(str, optional): A unique, case-sensitive token that you provide to ensure the idempotency of the request. Defaults to None.
        finding_publishing_frequency(str, optional): Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events). Defaults to None.
        status(str, optional): Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to ENABLED. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.macie.init.enable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.macie.init.enable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="enable_macie",
        op_kwargs={
            "clientToken": client_token,
            "findingPublishingFrequency": finding_publishing_frequency,
            "status": status,
        },
    )
