"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(
    hub,
    ctx,
    invitation_id: str,
    administrator_account_id: str = None,
    master_account: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts an Amazon Macie membership invitation that was received from a specific account.

    Args:
        administrator_account_id(str, optional): The Amazon Web Services account ID for the account that sent the invitation. Defaults to None.
        invitation_id(str): The unique identifier for the invitation to accept.
        master_account(str, optional): (Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.invitation.init.accept(ctx, invitation_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.invitation.init.accept invitation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="accept_invitation",
        op_kwargs={
            "administratorAccountId": administrator_account_id,
            "invitationId": invitation_id,
            "masterAccount": master_account,
        },
    )


async def create_multiple(
    hub,
    ctx,
    account_ids: List,
    disable_email_notification: bool = None,
    message: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sends an Amazon Macie membership invitation to one or more accounts.

    Args:
        account_ids(List): An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.
        disable_email_notification(bool, optional): Specifies whether to send an email notification to the root user of each account that the invitation will be sent to. This notification is in addition to an alert that the root user receives in Personal Health Dashboard. To send an email notification to the root user of each account, set this value to true. Defaults to None.
        message(str, optional): A custom message to include in the invitation. Amazon Macie adds this message to the standard content that it sends for an invitation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.invitation.init.create_multiple(ctx, account_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.invitation.init.create_multiple account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="create_invitations",
        op_kwargs={
            "accountIds": account_ids,
            "disableEmailNotification": disable_email_notification,
            "message": message,
        },
    )


async def decline(hub, ctx, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Declines Amazon Macie membership invitations that were received from specific accounts.

    Args:
        account_ids(List): An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to decline.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.invitation.init.decline(ctx, account_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.invitation.init.decline account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="decline_invitations",
        op_kwargs={"accountIds": account_ids},
    )


async def delete_multiple(hub, ctx, account_ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes Amazon Macie membership invitations that were received from specific accounts.

    Args:
        account_ids(List): An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.invitation.init.delete_multiple(ctx, account_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.invitation.init.delete_multiple account_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="delete_invitations",
        op_kwargs={"accountIds": account_ids},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about all the Amazon Macie membership invitations that were received by an account.

    Args:
        max_results(int, optional): The maximum number of items to include in each page of a paginated response. Defaults to None.
        next_token(str, optional): The nextToken string that specifies which page of results to return in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.invitation.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.invitation.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="list_invitations",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )
