"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, ids: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about one or more custom data identifiers.

    Args:
        ids(List, optional): An array of strings that lists the unique identifiers for the custom data identifiers to retrieve information about. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.get_custom_data_identifier.batch(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.get_custom_data_identifier.batch
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="batch_get_custom_data_identifiers",
        op_kwargs={"ids": ids},
    )
