"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub,
    ctx,
    group_by: str,
    finding_criteria: Dict = None,
    size: int = None,
    sort_criteria: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Retrieves (queries) aggregated statistical data about findings.

    Args:
        finding_criteria(Dict, optional): The criteria to use to filter the query results. Defaults to None.
        group_by(str): The finding property to use to group the query results. Valid values are: classificationDetails.jobId - The unique identifier for the classification job that produced the finding. resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to. severity.description - The severity level of the finding, such as High or Medium. type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.
        size(int, optional): The maximum number of items to include in each page of the response. Defaults to None.
        sort_criteria(Dict, optional): The criteria to use to sort the query results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.finding.statistic.get_all(ctx, group_by=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.finding.statistic.get_all group_by=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="get_finding_statistics",
        op_kwargs={
            "findingCriteria": finding_criteria,
            "groupBy": group_by,
            "size": size,
            "sortCriteria": sort_criteria,
        },
    )
