"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the configuration settings for publishing findings to Security Hub.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.finding.publication_configuration.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.finding.publication_configuration.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="get_findings_publication_configuration",
        op_kwargs={},
    )


async def put(
    hub, ctx, client_token: str = None, security_hub_configuration: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the configuration settings for publishing findings to Security Hub.

    Args:
        client_token(str, optional): A unique, case-sensitive token that you provide to ensure the idempotency of the request. Defaults to None.
        security_hub_configuration(Dict, optional): The configuration settings that determine which findings to publish to Security Hub. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.finding.publication_configuration.put(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.finding.publication_configuration.put
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="put_findings_publication_configuration",
        op_kwargs={
            "clientToken": client_token,
            "securityHubConfiguration": security_hub_configuration,
        },
    )
