"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(hub, ctx, finding_ids: List, sort_criteria: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the details of one or more findings.

    Args:
        finding_ids(List): An array of strings that lists the unique identifiers for the findings to retrieve.
        sort_criteria(Dict, optional): The criteria for sorting the results of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.finding.init.get_all(ctx, finding_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.finding.init.get_all finding_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="get_findings",
        op_kwargs={"findingIds": finding_ids, "sortCriteria": sort_criteria},
    )


async def list_all(
    hub,
    ctx,
    finding_criteria: Dict = None,
    max_results: int = None,
    next_token: str = None,
    sort_criteria: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a subset of information about one or more findings.

    Args:
        finding_criteria(Dict, optional): The criteria to use to filter the results. Defaults to None.
        max_results(int, optional): The maximum number of items to include in each page of the response. Defaults to None.
        next_token(str, optional): The nextToken string that specifies which page of results to return in a paginated response. Defaults to None.
        sort_criteria(Dict, optional): The criteria to use to sort the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.finding.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.finding.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="list_findings",
        op_kwargs={
            "findingCriteria": finding_criteria,
            "maxResults": max_results,
            "nextToken": next_token,
            "sortCriteria": sort_criteria,
        },
    )
