"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "filter"


async def create(
    hub,
    ctx,
    action: str,
    finding_criteria: Dict,
    name: str,
    client_token: str = None,
    description: str = None,
    position: int = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates and defines the criteria and other settings for a findings filter.

    Args:
        action(str): The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
        client_token(str, optional): A unique, case-sensitive token that you provide to ensure the idempotency of the request. Defaults to None.
        description(str, optional): A custom description of the filter. The description can contain as many as 512 characters. We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie. Defaults to None.
        finding_criteria(Dict): The criteria to use to filter findings.
        name(str): A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.
        position(int, optional): The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings. Defaults to None.
        tags(Dict, optional): A map of key-value pairs that specifies the tags to associate with the filter. A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.finding.filter_.create(
                ctx, action=value, finding_criteria=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.finding.filter.create action=value, finding_criteria=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="create_findings_filter",
        op_kwargs={
            "action": action,
            "clientToken": client_token,
            "description": description,
            "findingCriteria": finding_criteria,
            "name": name,
            "position": position,
            "tags": tags,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a findings filter.

    Args:
        id_(str): The unique identifier for the Amazon Macie resource or account that the request applies to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.finding.filter_.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.finding.filter.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="delete_findings_filter",
        op_kwargs={"id": id_},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the criteria and other settings for a findings filter.

    Args:
        id_(str): The unique identifier for the Amazon Macie resource or account that the request applies to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.finding.filter_.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.finding.filter.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="get_findings_filter",
        op_kwargs={"id": id_},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a subset of information about all the findings filters for an account.

    Args:
        max_results(int, optional): The maximum number of items to include in each page of a paginated response. Defaults to None.
        next_token(str, optional): The nextToken string that specifies which page of results to return in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.finding.filter_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.finding.filter.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="list_findings_filters",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    id_: str,
    action: str = None,
    description: str = None,
    finding_criteria: Dict = None,
    name: str = None,
    position: int = None,
    client_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the criteria and other settings for a findings filter.

    Args:
        action(str, optional): The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings. Defaults to None.
        description(str, optional): A custom description of the filter. The description can contain as many as 512 characters. We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie. Defaults to None.
        finding_criteria(Dict, optional): The criteria to use to filter findings. Defaults to None.
        id_(str): The unique identifier for the Amazon Macie resource or account that the request applies to.
        name(str, optional): A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie. Defaults to None.
        position(int, optional): The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings. Defaults to None.
        client_token(str, optional): A unique, case-sensitive token that you provide to ensure the idempotency of the request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.finding.filter_.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.finding.filter.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="update_findings_filter",
        op_kwargs={
            "action": action,
            "description": description,
            "findingCriteria": finding_criteria,
            "id": id_,
            "name": name,
            "position": position,
            "clientToken": client_token,
        },
    )
