"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    client_token: str = None,
    description: str = None,
    ignore_words: List = None,
    keywords: List = None,
    maximum_match_distance: int = None,
    name: str = None,
    regex: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates and defines the criteria and other settings for a custom data identifier.

    Args:
        client_token(str, optional): A unique, case-sensitive token that you provide to ensure the idempotency of the request. Defaults to None.
        description(str, optional): A custom description of the custom data identifier. The description can contain as many as 512 characters. We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see the identifier's description, depending on the actions that they're allowed to perform in Amazon Macie. Defaults to None.
        ignore_words(List, optional): An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 characters. Ignore words are case sensitive. Defaults to None.
        keywords(List, optional): An array that lists specific character sequences (keywords), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 characters. Keywords aren't case sensitive. Defaults to None.
        maximum_match_distance(int, optional): The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1-300 characters. The default value is 50. Defaults to None.
        name(str, optional): A custom name for the custom data identifier. The name can contain as many as 128 characters. We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see the identifier's name, depending on the actions that they're allowed to perform in Amazon Macie. Defaults to None.
        regex(str, optional): The regular expression (regex) that defines the pattern to match. The expression can contain as many as 512 characters. Defaults to None.
        tags(Dict, optional): A map of key-value pairs that specifies the tags to associate with the custom data identifier. A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.custom_data_identifier.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.custom_data_identifier.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="create_custom_data_identifier",
        op_kwargs={
            "clientToken": client_token,
            "description": description,
            "ignoreWords": ignore_words,
            "keywords": keywords,
            "maximumMatchDistance": maximum_match_distance,
            "name": name,
            "regex": regex,
            "tags": tags,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Soft deletes a custom data identifier.

    Args:
        id_(str): The unique identifier for the Amazon Macie resource or account that the request applies to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.custom_data_identifier.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.custom_data_identifier.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="delete_custom_data_identifier",
        op_kwargs={"id": id_},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the criteria and other settings for a custom data identifier.

    Args:
        id_(str): The unique identifier for the Amazon Macie resource or account that the request applies to.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.custom_data_identifier.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.custom_data_identifier.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="get_custom_data_identifier",
        op_kwargs={"id": id_},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a subset of information about all the custom data identifiers for an account.

    Args:
        max_results(int, optional): The maximum number of items to include in each page of the response. Defaults to None.
        next_token(str, optional): The nextToken string that specifies which page of results to return in a paginated response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.custom_data_identifier.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.custom_data_identifier.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="list_custom_data_identifiers",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def test(
    hub,
    ctx,
    regex: str,
    sample_text: str,
    ignore_words: List = None,
    keywords: List = None,
    maximum_match_distance: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Tests a custom data identifier.

    Args:
        ignore_words(List, optional): An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 characters. Ignore words are case sensitive. Defaults to None.
        keywords(List, optional): An array that lists specific character sequences (keywords), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 characters. Keywords aren't case sensitive. Defaults to None.
        maximum_match_distance(int, optional): The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1-300 characters. The default value is 50. Defaults to None.
        regex(str): The regular expression (regex) that defines the pattern to match. The expression can contain as many as 512 characters.
        sample_text(str): The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000 characters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.custom_data_identifier.test(
                ctx, regex=value, sample_text=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.custom_data_identifier.test regex=value, sample_text=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="test_custom_data_identifier",
        op_kwargs={
            "ignoreWords": ignore_words,
            "keywords": keywords,
            "maximumMatchDistance": maximum_match_distance,
            "regex": regex,
            "sampleText": sample_text,
        },
    )
