"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    client_token: str,
    job_type: str,
    name: str,
    s3_job_definition: Dict,
    custom_data_identifier_ids: List = None,
    description: str = None,
    initial_run: bool = None,
    sampling_percentage: int = None,
    schedule_frequency: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates and defines the settings for a classification job.

    Args:
        client_token(str): A unique, case-sensitive token that you provide to ensure the idempotency of the request.
        custom_data_identifier_ids(List, optional): The custom data identifiers to use for data analysis and classification. Defaults to None.
        description(str, optional): A custom description of the job. The description can contain as many as 200 characters. Defaults to None.
        initial_run(bool, optional): Specifies whether to analyze all existing, eligible objects immediately after the job is created. Defaults to None.
        job_type(str): The schedule for running the job. Valid values are: ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property. SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.
        name(str): A custom name for the job. The name can contain as many as 500 characters.
        s3_job_definition(Dict): The S3 buckets that contain the objects to analyze, and the scope of that analysis.
        sampling_percentage(int, optional): The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects. Defaults to None.
        schedule_frequency(Dict, optional): The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME. Defaults to None.
        tags(Dict, optional): A map of key-value pairs that specifies the tags to associate with the job. A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.classification.job.create(
                ctx, client_token=value, job_type=value, name=value, s3_job_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.classification.job.create client_token=value, job_type=value, name=value, s3_job_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="create_classification_job",
        op_kwargs={
            "clientToken": client_token,
            "customDataIdentifierIds": custom_data_identifier_ids,
            "description": description,
            "initialRun": initial_run,
            "jobType": job_type,
            "name": name,
            "s3JobDefinition": s3_job_definition,
            "samplingPercentage": sampling_percentage,
            "scheduleFrequency": schedule_frequency,
            "tags": tags,
        },
    )


async def describe(hub, ctx, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the status and settings for a classification job.

    Args:
        job_id(str): The unique identifier for the classification job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.classification.job.describe(ctx, job_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.classification.job.describe job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="describe_classification_job",
        op_kwargs={"jobId": job_id},
    )


async def list_all(
    hub,
    ctx,
    filter_criteria: Dict = None,
    max_results: int = None,
    next_token: str = None,
    sort_criteria: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a subset of information about one or more classification jobs.

    Args:
        filter_criteria(Dict, optional): The criteria to use to filter the results. Defaults to None.
        max_results(int, optional): The maximum number of items to include in each page of the response. Defaults to None.
        next_token(str, optional): The nextToken string that specifies which page of results to return in a paginated response. Defaults to None.
        sort_criteria(Dict, optional): The criteria to use to sort the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.classification.job.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.classification.job.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="list_classification_jobs",
        op_kwargs={
            "filterCriteria": filter_criteria,
            "maxResults": max_results,
            "nextToken": next_token,
            "sortCriteria": sort_criteria,
        },
    )


async def update(hub, ctx, job_id: str, job_status: str) -> Dict:
    r"""
    **Autogenerated function**

    Changes the status of a classification job.

    Args:
        job_id(str): The unique identifier for the classification job.
        job_status(str): The new status for the job. Valid values are: CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is IDLE, PAUSED, RUNNING, or USER_PAUSED. If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop all processing tasks for the job. You can't resume or restart a job after you cancel it. RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED. If you paused the job while it was actively running and you specify this value less than 30 days after you paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes the job according to the schedule and other settings for the job. USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE, PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately begins to pause all processing tasks for the job. If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job run expires and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.classification.job.update(
                ctx, job_id=value, job_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.classification.job.update job_id=value, job_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="update_classification_job",
        op_kwargs={"jobId": job_id, "jobStatus": job_status},
    )
