"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the configuration settings for storing data classification results.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.classification.export_configuration.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.classification.export_configuration.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="get_classification_export_configuration",
        op_kwargs={},
    )


async def put(hub, ctx, configuration: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates the configuration settings for storing data classification results.

    Args:
        configuration(Dict): The location to store data classification results in, and the encryption settings to use when storing results in that location.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.classification.export_configuration.put(
                ctx, configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.classification.export_configuration.put configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="put_classification_export_configuration",
        op_kwargs={"configuration": configuration},
    )
