"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, account_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

     Retrieves (queries) aggregated statistical data for all the S3 buckets that Amazon Macie monitors and analyzes.

    Args:
        account_id(str, optional): The unique identifier for the Amazon Web Services account. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.bucket.statistic.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.bucket.statistic.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="get_bucket_statistics",
        op_kwargs={"accountId": account_id},
    )
