"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    criteria: Dict = None,
    max_results: int = None,
    next_token: str = None,
    sort_criteria: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie monitors and analyzes.

    Args:
        criteria(Dict, optional): The criteria to use to filter the query results. Defaults to None.
        max_results(int, optional): The maximum number of items to include in each page of the response. The default value is 50. Defaults to None.
        next_token(str, optional): The nextToken string that specifies which page of results to return in a paginated response. Defaults to None.
        sort_criteria(Dict, optional): The criteria to use to sort the query results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.bucket.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.bucket.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie2",
        operation="describe_buckets",
        op_kwargs={
            "criteria": criteria,
            "maxResults": max_results,
            "nextToken": next_token,
            "sortCriteria": sort_criteria,
        },
    )
