"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the Amazon Macie administrator account for an account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie2.administrator_account.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie2.administrator_account.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="macie2", operation="get_administrator_account", op_kwargs={}
    )
