"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub, ctx, s3_resources: List, member_account_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Associates specified S3 resources with Amazon Macie Classic for monitoring and data classification. If memberAccountId isn't specified, the action associates specified S3 resources with Macie Classic for the current Macie Classic administrator account. If memberAccountId is specified, the action associates specified S3 resources with Macie Classic for the specified member account.

    Args:
        member_account_id(str, optional): The ID of the Amazon Macie Classic member account whose resources you want to associate with Macie Classic. . Defaults to None.
        s3_resources(List): The S3 resources that you want to associate with Amazon Macie Classic for monitoring and data classification. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie.s3_resource.associate(ctx, s3_resources=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie.s3_resource.associate s3_resources=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie",
        operation="associate_s3_resources",
        op_kwargs={"memberAccountId": member_account_id, "s3Resources": s3_resources},
    )


async def disassociate(
    hub, ctx, associated_s3_resources: List, member_account_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Removes specified S3 resources from being monitored by Amazon Macie Classic. If memberAccountId isn't specified, the action removes specified S3 resources from Macie Classic for the current Macie Classic administrator account. If memberAccountId is specified, the action removes specified S3 resources from Macie Classic for the specified member account.

    Args:
        member_account_id(str, optional): The ID of the Amazon Macie Classic member account whose resources you want to remove from being monitored by Macie Classic. . Defaults to None.
        associated_s3_resources(List): The S3 resources (buckets or prefixes) that you want to remove from being monitored and classified by Amazon Macie Classic. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie.s3_resource.disassociate(
                ctx, associated_s3_resources=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie.s3_resource.disassociate associated_s3_resources=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie",
        operation="disassociate_s3_resources",
        op_kwargs={
            "memberAccountId": member_account_id,
            "associatedS3Resources": associated_s3_resources,
        },
    )


async def list_all(
    hub,
    ctx,
    member_account_id: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the S3 resources associated with Amazon Macie Classic. If memberAccountId isn't specified, the action lists the S3 resources associated with Macie Classic for the current Macie Classic administrator account. If memberAccountId is specified, the action lists the S3 resources associated with Macie Classic for the specified member account.

    Args:
        member_account_id(str, optional): The Amazon Macie Classic member account ID whose associated S3 resources you want to list. . Defaults to None.
        next_token(str, optional): Use this parameter when paginating results. Set its value to null on your first call to the ListS3Resources action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data. . Defaults to None.
        max_results(int, optional): Use this parameter to indicate the maximum number of items that you want in the response. The default value is 250. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie.s3_resource.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie.s3_resource.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie",
        operation="list_s3_resources",
        op_kwargs={
            "memberAccountId": member_account_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update_multiple(
    hub, ctx, s3_resources_update: List, member_account_id: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the classification types for the specified S3 resources. If memberAccountId isn't specified, the action updates the classification types of the S3 resources associated with Amazon Macie Classic for the current Macie Classic administrator account. If memberAccountId is specified, the action updates the classification types of the S3 resources associated with Macie Classic for the specified member account.

    Args:
        member_account_id(str, optional): The AWS ID of the Amazon Macie Classic member account whose S3 resources' classification types you want to update. . Defaults to None.
        s3_resources_update(List): The S3 resources whose classification types you want to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.macie.s3_resource.update_multiple(
                ctx, s3_resources_update=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.macie.s3_resource.update_multiple s3_resources_update=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="macie",
        operation="update_s3_resources",
        op_kwargs={
            "memberAccountId": member_account_id,
            "s3ResourcesUpdate": s3_resources_update,
        },
    )
