"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, tags: List, resource_id: str, resource_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value. If you add a tag using a key that is already associated with the ML object, AddTags updates the tag's value.

    Args:
        tags(List): The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates a tag with the specified key and a value of null.
        resource_id(str): The ID of the ML object to tag. For example, exampleModelId.
        resource_type(str): The type of the ML object to tag.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.tags.add(
                ctx, tags=value, resource_id=value, resource_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.tags.add tags=value, resource_id=value, resource_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="add_tags",
        op_kwargs={
            "Tags": tags,
            "ResourceId": resource_id,
            "ResourceType": resource_type,
        },
    )


async def delete(
    hub, ctx, tag_keys: List, resource_id: str, resource_type: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags. If you specify a tag that doesn't exist, Amazon ML ignores it.

    Args:
        tag_keys(List): One or more tags to delete.
        resource_id(str): The ID of the tagged ML object. For example, exampleModelId.
        resource_type(str): The type of the tagged ML object.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.tags.delete(
                ctx, tag_keys=value, resource_id=value, resource_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.tags.delete tag_keys=value, resource_id=value, resource_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="delete_tags",
        op_kwargs={
            "TagKeys": tag_keys,
            "ResourceId": resource_id,
            "ResourceType": resource_type,
        },
    )


async def describe(hub, ctx, resource_id: str, resource_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes one or more of the tags for your Amazon ML object.

    Args:
        resource_id(str): The ID of the ML object. For example, exampleModelId. .
        resource_type(str): The type of the ML object.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.tags.describe(
                ctx, resource_id=value, resource_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.tags.describe resource_id=value, resource_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="describe_tags",
        op_kwargs={"ResourceId": resource_id, "ResourceType": resource_type},
    )
