"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, ml_model_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a real-time endpoint for the MLModel. The endpoint contains the URI of the MLModel; that is, the location to send real-time prediction requests for the specified MLModel.

    Args:
        ml_model_id(str): The ID assigned to the MLModel during creation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.realtime_endpoint.create(ctx, ml_model_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.realtime_endpoint.create ml_model_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="create_realtime_endpoint",
        op_kwargs={"MLModelId": ml_model_id},
    )


async def delete(hub, ctx, ml_model_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a real time endpoint of an MLModel.

    Args:
        ml_model_id(str): The ID assigned to the MLModel during creation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.machinelearning.realtime_endpoint.delete(ctx, ml_model_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.machinelearning.realtime_endpoint.delete ml_model_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="machinelearning",
        operation="delete_realtime_endpoint",
        op_kwargs={"MLModelId": ml_model_id},
    )
